/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity.modifiers.misc;

import com.xiaoyue.tinkers_ingenuity.TinkersIngenuity;
import com.xiaoyue.tinkers_ingenuity.generic.XIRModifier;
import com.xiaoyue.tinkers_ingenuity.utils.ItemUtils;
import com.xiaoyue.tinkers_ingenuity.utils.TooltipUtils;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class Alien
extends XIRModifier {
    private final ResourceLocation DAMAGE = TinkersIngenuity.location("damage_increase");
    private final ResourceLocation SPEED = TinkersIngenuity.location("speed_increase");
    private final ResourceLocation MIN_SPEED = TinkersIngenuity.location("min_speed_increase");

    private int getAllUp(IToolStackView tool) {
        ModDataNBT toolData = tool.getPersistentData();
        return toolData.getInt(this.DAMAGE) + toolData.getInt(this.SPEED) + toolData.getInt(this.MIN_SPEED);
    }

    private boolean canUp(IToolStackView tool, int level) {
        return this.getAllUp(tool) <= 80 * level;
    }

    @Override
    public void onInventoryTick(IToolStackView tool, ModifierEntry modifier, Level world, LivingEntity entity, int index, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        int level = modifier.getLevel();
        if (isCorrectSlot && entity.f_19797_ % 1200 == 0 && this.canUp(tool, level)) {
            ModDataNBT toolData = tool.getPersistentData();
            float random = RANDOM.nextFloat();
            if ((double)random < 0.4) {
                toolData.putInt(this.DAMAGE, toolData.getInt(this.DAMAGE) + 1);
            } else if ((double)random > 0.4 && (double)random < 0.7) {
                toolData.putInt(this.SPEED, toolData.getInt(this.SPEED) + 1);
            } else if ((double)random > 0.7) {
                toolData.putInt(this.MIN_SPEED, toolData.getInt(this.MIN_SPEED) + 1);
            }
        }
    }

    @Override
    public float onModifyMeleeDamage(IToolStackView tool, int level, ToolAttackContext context, LivingEntity attacker, LivingEntity target, float baseDamage, float actualDamage) {
        if (tool.getPersistentData().contains(this.DAMAGE, 5)) {
            return actualDamage * (1.0f + (float)tool.getPersistentData().getInt(this.DAMAGE) * 0.01f);
        }
        return actualDamage;
    }

    @Override
    public void onArrowShoot(IToolStackView bow, int level, LivingEntity shooter, Projectile projectile, AbstractArrow arrow, NamespacedNBT namespacedNBT, boolean primary) {
        if (bow.getPersistentData().contains(this.DAMAGE, 5)) {
            arrow.m_36781_(arrow.m_36789_() * (double)(1.0f + (float)bow.getPersistentData().getInt(this.DAMAGE) * 0.01f));
        }
    }

    @Override
    public void addAttributes(IToolStackView tool, ModifierEntry modifier, EquipmentSlot slot, BiConsumer<Attribute, AttributeModifier> consumer) {
        if (slot == EquipmentSlot.MAINHAND) {
            ModDataNBT toolData = tool.getPersistentData();
            consumer.accept(Attributes.f_22283_, ItemUtils.mulBaseAttr(slot, ItemUtils.getAttrName("attack_speed", slot), (double)toolData.getInt(this.SPEED) * 0.01));
        }
    }

    @Override
    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, FloatToolStat stat, float baseValue, float multiplier) {
        if (tool.getPersistentData().contains(this.SPEED, 5)) {
            ModDataNBT toolData = tool.getPersistentData();
            if (stat == ToolStats.DRAW_SPEED) {
                return baseValue * (1.0f + (float)toolData.getInt(this.SPEED) * 0.01f);
            }
        }
        return baseValue;
    }

    @Override
    public void onBreakSpeed(IToolStackView tool, ModifierEntry modifier, PlayerEvent.BreakSpeed event, Direction sidHit, boolean isEffective, float miningSpeedModifier) {
        if (tool.getPersistentData().contains(this.MIN_SPEED, 5)) {
            ModDataNBT toolData = tool.getPersistentData();
            event.setNewSpeed(event.getNewSpeed() * (1.0f + (float)toolData.getInt(this.MIN_SPEED) * 0.01f));
        }
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> list, TooltipKey key, TooltipFlag tooltipFlag) {
        if (player != null) {
            ModDataNBT toolData = tool.getPersistentData();
            TooltipModifierHook.addPercentBoost((Modifier)this, (Component)TooltipUtils.addTooltip("alien.damage_increase"), (double)((float)toolData.getInt(this.DAMAGE) * 0.01f), list);
            TooltipModifierHook.addPercentBoost((Modifier)this, (Component)TooltipUtils.addTooltip("alien.speed_increase"), (double)((float)toolData.getInt(this.SPEED) * 0.01f), list);
            TooltipModifierHook.addPercentBoost((Modifier)this, (Component)TooltipUtils.addTooltip("alien.min_speed_increase"), (double)((float)toolData.getInt(this.MIN_SPEED) * 0.01f), list);
        }
    }
}

